/************************************************************/
/* PROJECT NAME: AtoD	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin   tmartin@hitex.co.uk             */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM 	V1.3		                    */
/* Assembler:    				                            */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2004						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:                                                */
/*                                                          */
/* Example Discrete Fourier Transform						*/
/*															*/
/* Demonstrates Fourier transform					 		*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB2100								*/
/************************************************************/

#include "lpc21xx.h"
#include <math.h>
unsigned val = 0;
float XX[511];
float REX[256];
float IMX[256];
float MAG[256];

int main(void)
{
 

unsigned index,K,I,N;
float PI =3.14159265;
N = 512; 
VPBDIV = 0x02;			//Set the Pclk to 30 Mhz
IODIR1 = 0x00FF0000;    // P1.16..23 defined as Outputs  
ADCR   = 0x00270601;    // Setup A/D: 10-bit AIN0 @ 3MHz 
ADCR  |= 0x01000000;    // Start A/D Conversion 

while(1)
{

/*for (index = 0;index<(N-1);index++)
{ 		  
do
{
    val = ADDR;                   // Read A/D Data Register 
}        
while ((val & 0x80000000) == 0);  //Wait for the conversion to complete
XX[index] =(float) ((val >> 6) & 0x03FF);  //Extract the A/D result 
}
  */
XX[index] = 0;

for (index = 1;index<(N-1);index++)
{
XX[index] = 0.5;
}
for (index = 0;index < 256;index++)
{
REX[index] = 0;
IMX[index] = 0;
}

for( K = 0;K<256;K++)
{
for(I = 0;I<511;I++)
{
REX[K] = REX[K] + XX[I]* cos(2 * PI * K * I / N);
IMX[K] = IMX[K] - XX[I]* sin(2 * PI * K * I / N);
}
}

for (K = 0;K<(N/2);K++)
{
;

}

}
}